/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.condition;

import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.condition.AbstractQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionProviderType;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NoHealConditionProvider
extends AbstractQuestConditionProvider<NoHealConditionProvider>
implements IQuestCondition {
    private final ITextComponent[] descriptors = NoHealConditionProvider.expandWithShortLocalizations(new ITextComponent[]{new TranslationTextComponent(this.getLocalizationString())});

    public NoHealConditionProvider(QuestConditionProviderType<?> type) {
        super(type);
    }

    public static NoHealConditionProvider fromNbt(QuestConditionProviderType<NoHealConditionProvider> type, CompoundNBT nbt) {
        return new NoHealConditionProvider(type);
    }

    @Override
    public ITextComponent getDescriptor(boolean shortDesc) {
        return this.descriptors[shortDesc ? 1 : 0];
    }

    @Override
    public boolean isValid(PlayerEntity player, IPropertyReader reader) {
        float healthStat = reader.getProperty(QuestProperties.HEALTH_STATUS).floatValue();
        float health = player.func_110143_aJ();
        return health <= healthStat;
    }

    @Override
    public NoHealConditionProvider makeConditionInstance() {
        return this;
    }

    @Override
    public IQuestConditionProvider<?> getProviderType() {
        return this;
    }
}

